package com.bxm.localnews.user.enums;

/**
 * 用户行为类型枚举
 *
 * @author liujia
 * @date 2020-07-16 14:41
 **/
public enum UserActionEnum {

    /**
     * 用户切换定位
     */
    LOCATION,

    /**
     * 用户修改基础属性，性别、年龄等
     */
    ATTRIBUTE,

    /**
     * 冗余信息更新，包括昵称、头像等
     */
    REDUNDANCY,

    /**
     * 用户最后活跃信息
     */
    ACTIVE,

    /**
     * 用户退出登录
     */
    LOGOUT,
}
