package com.bxm.localnews.user.enums;

import lombok.Getter;

/**
 * 用户封面状态
 *
 * @author lowi
 * @date 2021/3/5 9:36
 */
@Getter
public enum UserCoverStatusEnum {
    /**
     * 0 待审核
     * 1 审核通过
     * 2 审核拒绝
     */
    NO_AUDIT(0),
    AUDIT_PASS(1),
    AUDIT_REFUSE(2),
    ;

    private Integer status;

    UserCoverStatusEnum(Integer status) {
        this.status = status;
    }
}
