package com.bxm.localnews.user.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 用户收益状态
 *
 * @author lowi
 * @date 2020/12/16 14:58
 */
@Getter
public enum UserEarningsStatusEnum {
    /**
     * 用户收益状态
     */
    DEFAULT(-1, ""),
    NO_SETTLE(1, "待核销"),
    SETTLE(2, "已结算"),
    WAIT_UP(3, "待升级"),
    CANCEL(4, "已失效"),
    ;

    private Integer status;

    private String desc;

    UserEarningsStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static UserEarningsStatusEnum get(Integer type) {
        for (UserEarningsStatusEnum earningsStatusEnum : values()) {
            if (Objects.equals(type, earningsStatusEnum.getStatus())) {
                return earningsStatusEnum;
            }
        }
        return UserEarningsStatusEnum.DEFAULT;
    }
}
