package com.bxm.localnews.user.enums;

import lombok.Getter;

/**
 * 温暖值规则枚举
 *
 * @author lowi
 * @date 2021/3/2 10:36
 */
@Getter
public enum WarmRuleEnum {

    /**
     * 默认规则，测试使用
     */
    DEFAULT,
    /**
     * 注册
     */
    REGISTER,
    /**
     * 完善个人资料
     */
    FINISH_ONESELF_DATA,
    /**
     * 新人贴
     */
    NEW_PEOPLE_POST,
    /**
     * 登录
     */
    LOGIN,
    /**
     * 签到
     */
    SIGN,
    /**
     * 连续签到
     */
    CONTINUITY_SIGN,
    /**
     * 帖子审核通过
     */
    POST_AUDIT_PASS,
    /**
     * 帖子上头条
     */
    POST_UP_RECOMMEND,

    /**
     * 评论
     */
    COMMENT,
    /**
     * 评论上热门
     */
    COMMENT_UP_HOT,

    /**
     * 购买商品
     */
    BUY_GOODS,

    /**
     * 完成商家认证
     */
    FINISH_MERCHANT_AUTH,

    /**
     * 发布的帖子被运营删除
     */
    OPERATE_DEL_POST,

    /**
     * 发布的审核通过的帖子被自己删除
     */
    ONESELF_DEL_POST,

    /**
     * 发布的帖子取消推荐
     */
    POST_DOWN_RECOMMEND,

    /**
     * 发布的评论被自己删除
     */
    ONESELF_DEL_COMMENT,

    /**
     * 发布的评论被运营删除
     */
    OPERATE_DEL_COMMENT,

    /**
     * 自购商品退款
     */
    REFUND_GOODS,
    /**
     * 注销账号
     */
    DEL_ACCOUNT,


}
