package com.bxm.localnews.user.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * =================================== user 模块相关缓存键值 用户信息 ===================================
     */
    public static KeyGenerator USER_CACHE_INFO = DefaultKeyGenerator.build("user", "cache", "info");

    /**
     * 用户标签缓存键值
     */
    public static KeyGenerator USER_TAG = DefaultKeyGenerator.build("user", "cache", "user_tag");

    /**
     * 用户缓存相关键值
     */
    public static KeyGenerator USER_VISIT_NUM = DefaultKeyGenerator.build("user", "cache");

    /**
     * 用户VIP信息相关键值
     */
    public static KeyGenerator USER_VIP_INFO = DefaultKeyGenerator.build("user", "cache", "vip");

    /**
     * 用户VIP激活码剩余使用次数
     */
    public static KeyGenerator USER_VIP_CODE_LEFT_USE_NUM = DefaultKeyGenerator.build("user", "cache", "userVipCodeLeftUseNum");

    /**
     * 同城人推荐缓存
     */
    public static KeyGenerator USER_RECOMMEND = DefaultKeyGenerator.build("user", "recommend");

    /**
     * 用户账户提现弹窗
     */
    public static KeyGenerator USER_WITHDRAW_POP = DefaultKeyGenerator.build("user", "account_withdraw_pop", "");

    /**
     * 首次登录新用户
     */
    public static KeyGenerator NEW_USER_LOGIN = DefaultKeyGenerator.build("user", "new_login");

    /**
     * 用户提现、二次登录状态：1 已提现 2 第二天登录
     */
    public static KeyGenerator USER_WITHDRAW_LOGIN_TWICE = DefaultKeyGenerator.build("user", "withdraw_login_twice");

    /**
     * 用户关注列表
     */
    public static KeyGenerator USER_FOLLOW_LIST = DefaultKeyGenerator.build("user", "follow_list");

    /**
     * 用户关注的通知消息,用于在客户端私聊时进行显示
     */
    public static KeyGenerator COMSUME_FOLLOW_INFO = DefaultKeyGenerator.build("user", "comsume", "follow");

    /**
     * 记录 用户据上次登录时间有多少人访问主页,并发送系统消息的时间
     */
    public static KeyGenerator USER_ACCESS_MESSAGE = DefaultKeyGenerator.build("user", "homepage", "systemmessage");

    /**
     * 拉黑缓存
     */
    public static KeyGenerator USER_BLOCK_LIMIT = DefaultKeyGenerator.build("user", "limit", "block");

    /**
     * 推荐降权缓存
     */
    public static KeyGenerator RECOMMEND_BLOCK_LIMIT = DefaultKeyGenerator.build("user", "limit", "recommend");

    /**
     * 用户赠送小红花队列
     */
    public static KeyGenerator USER_PRESENT_FLOWER_QUEUE = DefaultKeyGenerator.build("user", "flower", "queue");

    /**
     * 用户赠送小红花处理器
     */
    public static KeyGenerator USER_PRESENT_FLOWER_PROCESSOR = DefaultKeyGenerator.build("user", "flower", "processor");

    /**
     * 用户账号缓存
     * V3.4.0 从hash修改为string，修改了缓存名称
     */
    public static KeyGenerator USER_ACCOUNT_CACHE = DefaultKeyGenerator.build("user", "cache", "userAccount");

    /**
     * 各个地区的用户总数
     */
    public static KeyGenerator USER_TOTAL_CACHE = DefaultKeyGenerator.build("user", "cache", "total_rank");

    /**
     * 各个地区的VIP总数
     */
    public static KeyGenerator USER_TOTAL_VIP_CACHE = DefaultKeyGenerator.build("user", "cache", "total_vip_rank");

    /**
     * 各个地区的省钱排行榜
     */
    public static KeyGenerator AREA_REBATE_RANK_CACHE = DefaultKeyGenerator.build("user", "cache", "rebateRank");

    /**
     * 各个地区的收徒数量排行榜
     */
    public static KeyGenerator AREA_INVITE_RANK_CACHE = DefaultKeyGenerator.build("user", "cache", "inviteRank");

    /**
     * 用户产生省钱金额时记录，用于在用户进入主页时进行动画显示
     */
    public static KeyGenerator HAS_NEW_SAVE_CASH_EVENT_CACHE = DefaultKeyGenerator.build("user", "cache", "newSaveCashEvent");

    /**
     * 用户栏目管理
     */
    public static KeyGenerator USER_LOCATION_LIST_CACHE = DefaultKeyGenerator.build("user", "location", "userLocationCache");

    /**
     * 当前的栏目区域版本管理
     */
    public static KeyGenerator LOCATION_VERSION_CACHE = DefaultKeyGenerator.build("user", "location", "versionLocationCache");

    /**
     * 当前的用户栏目区域版本管理
     */
    public static KeyGenerator USER_LOCATION_VERSION_CACHE = DefaultKeyGenerator.build("user", "location", "userVersionLocationCache");
    /**
     * =================================== message 模块相关缓存键值 ===================================
     */
    /**
     * 用户消息通知红点缓存
     */
    public static KeyGenerator MSG_RED_POINT = DefaultKeyGenerator.build("message", "red_point");

    /**
     * VIP激活码自增值，仅redis中有存储
     */
    public static KeyGenerator VIP_CODE_KEY = DefaultKeyGenerator.build("user", "increment", "code");

    /**
     * VIP卡号的自增下标
     */
    public static KeyGenerator VIP_CARD_INDEX_KEY = DefaultKeyGenerator.build("user", "increment", "card");

    /**
     * =================================== base 模块相关缓存键值 用户信息 ===================================
     */

    /**
     * channel 所有渠道信息
     */
    public static KeyGenerator BASE_CHANNEL = DefaultKeyGenerator.build("base", "channel");

    /**
     * 用户弹窗缓存
     */
    public static KeyGenerator USER_CACHE_POPUP = DefaultKeyGenerator.build("thirdparty", "pop", "cache");

    /**
     * 3.1.2新增bug处理，是否让用户重新登录
     */
    public static KeyGenerator IS_NEED_RE_LOGIN = DefaultKeyGenerator.build("base", "is_need_re_login");
}
