package com.bxm.localnews.user.enums;

/**
 * 手机类型定义
 * Created by Administrator on 2018/3/6.
 */
public enum PhoneTyeEnum {
    /**
     * 安卓
     */
    ANDROID("1", "android"),
    /**
     * IOS
     */
    IOS("2", "ios"),
    H5("3", "h5");

    private String type;

    private String desc;

    PhoneTyeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getPhoneTyeEnum(String type) {
        for (PhoneTyeEnum phoneTyeEnum : PhoneTyeEnum.values()) {
            if (phoneTyeEnum.getType().equals(type)) {
                return phoneTyeEnum.getDesc();
            }
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
