package com.bxm.localnews.user.event;

import com.bxm.localnews.user.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户定位变更事件
 *
 * @author liujia
 * @date 2020-07-16 14:48
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class LocationActionEvent extends UserActionEvent {

    /**
     * 用户行为
     */
    private final UserActionEnum action = UserActionEnum.LOCATION;

    /**
     * 当前最新定位的编码
     */
    private String locationCode;

    /**
     * 当前最新定位的简称
     */
    private String locationName;

    /**
     * 上次定位的编码
     */
    private String oldLocationCode;

}
