package com.bxm.localnews.user.enums;

/**
 * 激活码类型,不同的激活码逻辑略有区别
 *
 * @author liujia
 * @date 2020/6/3 09:31
 **/
public enum ActiveCodeTypeEnum {
    /**
     * 生成的实体卡对应的激活码，存在与之对应的卡号
     */
    CHANNEL(0),

    /**
     * 通过支付VIP获取的可用于分享的激活码
     */
    PAYMENT(1),

    /**
     * 通过他人的激活码激活了VIP，然后产生的用户激活码
     */
    SUB(2),

    /**
     * 内部直接触发激活
     */
    MANUAL(3),
    ;

    private Integer code;

    ActiveCodeTypeEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }
}
