package com.bxm.localnews.user.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.vo.CashFlow;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/5 19:48
 * @desc
 */
@Mapper
public interface CashFlowMapper {

    /**
     * 查询流水信息
     *
     * @param cashFlowParam
     * @return
     */
    List<CashFlow> queryCashFlows(CashFlowParam cashFlowParam);

    List<UserDayCashDTO> querySevenDayCashFlows(@Param("userId") Long userId);

    /**
     * 添加用户流水
     *
     * @return
     */
    int addCashFlow(CashFlow cashFlow);

    /**
     * 更新流水
     *
     * @param cashFlow
     * @return
     */
    int updateCashFlow(CashFlow cashFlow);

    /**
     * 更新流水信息
     *
     * @param id
     * @param convertType
     * @return
     */
    int updateCovertTypeByCashFlow(@Param("id") Long id, @Param("convertType") String convertType);

    /**
     * 获取账户自己的赏金
     *
     * @param userId
     * @return
     */
    BigDecimal getMySelfBounty(@Param("userId") Long userId);

    /**
     * 获取用户红包
     *
     * @param userId
     * @return
     */
    BigDecimal getMyRedPacket(@Param("userId") Long userId);
}
