package com.bxm.localnews.user.domain;

import java.util.Map;

import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.vo.PushInfo;
import com.bxm.localnews.user.vo.User;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserMapper {

    int insertSelective(User record);

    User selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(User record);

    boolean updateUserBlack(Map<String, Object> map);

    User findByEquipment(@Param("equipment") String equipment);

    Long checkExistEquipment(@Param("equipment") String equipment);

    User findByPhone(@Param("phone") String phone);

    User findByWeixin(@Param("weixin") String weixin);

    User findByPushToken(@Param("pushToken") String pushToken);

    User getUserByRefreshToken(@Param("userId") long userId, @Param("refreshtoken") String refreshtoken);

    User selectByUserId(@Param("userId") long userId);

    void savePushInfo(PushInfo pushInfo);

    void clearPushInfo(@Param("userId") long userId);

    LocationUserInfoDTO getLocationUserInfo(@Param("userId") Long userId);

    int updateUserReceiveRedPacket(@Param("userId") Long userId);

    int updateUserToRisk(@Param("userId") Long userId);

    int addPostNum(@Param("userId") Long userId);

    int minusPostNum(@Param("userId") Long userId);

    int addReplyNum(@Param("userId") Long userId);

    int minusReplyNum(@Param("userId") Long userId);
}
