package com.bxm.localnews.user.dto;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 14:52
 * @desc
 */
@ApiModel(description = "用户邀请记录信息")
public class InviteRecordDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("被邀请人名称")
    private String invitedUserName;

    @ApiModelProperty("被邀请人头像")
    private String invitedUserImg;

    @ApiModelProperty("奖励数量")
    private BigDecimal award;

    @ApiModelProperty("邀请类型：还未登录APP、还未成功提现、已成功提现、已过期作废、不是新用户")
    private String inviteState;

    @ApiModelProperty("变更时间")
    private Date modifyTime;

    @ApiModelProperty("失效时间")
    private Date effectTime;

    @ApiModelProperty("是否有效 0:无效 1有效")
    private Byte status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInvitedUserName() {
        return invitedUserName;
    }

    public void setInvitedUserName(String invitedUserName) {
        this.invitedUserName = invitedUserName;
    }

    public String getInvitedUserImg() {
        return invitedUserImg;
    }

    public void setInvitedUserImg(String invitedUserImg) {
        this.invitedUserImg = invitedUserImg;
    }

    public BigDecimal getAward() {
        return award;
    }

    public void setAward(BigDecimal award) {
        this.award = award;
    }

    public String getInviteState() {
        return inviteState;
    }

    public void setInviteState(String inviteState) {
        this.inviteState = inviteState;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }
}
