package com.bxm.localnews.user.dto;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/5 11:30
 * @desc
 */
@ApiModel(description = "用户提现对应信息")
public class UserWithdrawDTO {

    @ApiModelProperty("提现编号")
    private String withdrawNum;

    @ApiModelProperty("提现状态 1-待审核 2-支付中 3-支付成功 4-支付失败")
    private Byte status;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("提现金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "返回消息", hidden = true)
    private String remark;

    public String getWithdrawNum() {
        return withdrawNum;
    }

    public void setWithdrawNum(String withdrawNum) {
        this.withdrawNum = withdrawNum;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
