package com.bxm.localnews.user.domain;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.vo.WithdrawFlow;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/6 13:51
 * @desc
 */
@Mapper
public interface WithdrawFlowMapper {

    /**
     * 获取用户最后一笔提现信息
     *
     * @param userId
     * @return
     */
    WithdrawFlow getUserLastWithdraw(@Param("userId") Long userId);

    List<WithdrawFlow> getUserTodayWithdraw(@Param("userId") Long userId, @Param("state") Byte state, @Param("amount") BigDecimal amount);

    int addWithdrawFlow(WithdrawFlow withdrawFlow);

    int updateWithdrawFlow(WithdrawFlow withdrawFlow);

    WithdrawFlow getWithdrawFlowById(@Param("id") Long id);

    /**
     * 获取小程序用户当天已提现金额
     *
     * @param userId
     * @param openId
     * @return
     */
    BigDecimal getMiniAppUserWithdraw(@Param("userId") Long userId, @Param("openId") String openId,
                                      @Param("state") Byte state);
}
