package com.bxm.localnews.user.dto;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/6 15:05
 * @desc
 */
@ApiModel(description = "用户个人中心账户和金币")
public class UserCashGoldDTO {

    @ApiModelProperty("我的钱包")
    private BigDecimal cash;

    @ApiModelProperty("我的金币")
    private Integer gold;

    @ApiModelProperty("金币转换现金金额")
    private BigDecimal convertCash;

    @ApiModelProperty("累计金币")
    private Integer totalGold;

    public UserCashGoldDTO() {
    }

    public UserCashGoldDTO(BigDecimal cash, Integer gold) {
        this.cash = cash;
        this.gold = gold;
    }

    public UserCashGoldDTO(BigDecimal cash, Integer gold, BigDecimal convertCash, Integer totalGold) {
        this.cash = cash;
        this.gold = gold;
        this.convertCash = convertCash;
        this.totalGold = totalGold;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public Integer getGold() {
        return gold;
    }

    public void setGold(Integer gold) {
        this.gold = gold;
    }

    public BigDecimal getConvertCash() {
        return convertCash;
    }

    public void setConvertCash(BigDecimal convertCash) {
        this.convertCash = convertCash;
    }

    public Integer getTotalGold() {
        return totalGold;
    }

    public void setTotalGold(Integer totalGold) {
        this.totalGold = totalGold;
    }
}
