package com.bxm.localnews.user.vo;

import java.util.Date;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 17:32
 * @desc
 */
@ApiModel(description = "用户金币流水记录")
public class GoldFlow extends BaseBean implements IUserIdSharding {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("流水对应金额")
    private Integer amount;

    @ApiModelProperty("流水记录类型")
    private String type;

    @ApiModelProperty("备注记录")
    private String remark;

    @ApiModelProperty("关联业务id")
    private Long relationId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建时间")
    private String content;

    @ApiModelProperty("创建时间")
    private String reason;

    public GoldFlow() {
    }

    public GoldFlow(Long id, Long userId, Integer amount, String type, Long relationId,String content) {
        this.id = id;
        this.userId = userId;
        this.amount = amount;
        this.type = type;
        this.relationId = relationId;
        this.remark = GoldFlowTypeEnum.valueOf(type).getDesc();
        this.createTime = new Date();
        this.content =  content;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}
