package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.vo.UserAccount;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/5 19:49
 * @desc
 */
@Mapper
public interface UserAccountMapper {

    /**
     * 获取用户账户信息
     * @param userId
     * @return
     */
    UserAccount getUserAccount(@Param("userId") Long userId);

    /**
     * 创建用户账户信息
     * @param userAccount
     * @return
     */
    int addUserAccount(UserAccount userAccount);

    /**
     * 使用version作为乐观锁更新账号信息,所有账号的涉及到的金币、金额变更均使用此方法
     * 不要额外定义更新的方法了，具体使用详见 {@link com.bxm.localnews.user.enums.AccountActionEnum}
     * @param userAccount 账号信息，其中仅包含需要更新的字段
     * @return 更新结果，大于0表示更新成功
     */
    int updateUserAccountWithVersion(UserAccount userAccount);

    /**
     * 获取账户临时金额
     * @param userId
     * @return
     */
    BigDecimal getAccountTempCash(@Param("userId") Long userId);

}
