package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.model.param.earnings.UserEarningsParam;
import com.bxm.localnews.user.model.vo.earnings.UserEarningsListVO;
import com.bxm.localnews.user.vo.UserEarnings;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserEarningsMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(UserEarnings record);

    UserEarnings selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserEarnings record);

    int updateByPrimaryKey(UserEarnings record);

    /**
     * 获取用户收益列表
     *
     * @param param 请求参数
     * @return 用户收益列表
     */
    List<UserEarnings> getUserEarningsList(UserEarningsParam param);

    /**
     * 获取用户收益流水
     *
     * @param userId       用户id
     * @param earningsType 收益类型
     * @param relationId   收益类型对应的id
     * @return 用户收益
     */
    UserEarnings getEarningsByTypeAndRelationId(@Param("userId") Long userId,
                                                @Param("earningsType") Integer earningsType,
                                                @Param("relationId") Long relationId);
}