package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "用户账户信息")
@Data
public class UserAccountDTO {

    /**
     * 用户实体的版本信息
     * 用于控制缓存是否需要更新，避免直接删除整个缓存导致缓存穿透
     * 当缓存中加载的"v"不等于"CURRENT_VERSION"，说明需要重新加载用户的缓存
     */
    public static final int CURRENT_VERSION = 3;

    /**
     * 设置初始值，缓存回写时会被覆盖
     */
    @ApiModelProperty(value = "当前对象的版本", hidden = true)
    private int v = CURRENT_VERSION;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("总共拥有金币数量（包括已消费的金币）")
    private Integer totalGold;

    @ApiModelProperty("当前可用金币")
    private Integer usableGold;

    @ApiModelProperty("可提现(现金余额)金额")
    private BigDecimal drawablelCash;

    /**
     * 用户临时金额 + 永久金额而成
     */
    @ApiModelProperty("未到账金额")
    private BigDecimal notArriveCash;

    @ApiModelProperty("累计收入(普通用户的--我的收益---达人的-全部收益)")
    private BigDecimal totalCash;

    @ApiModelProperty("是否出现提现弹窗")
    private Boolean enablePopWithdraw = false;

    /**
     * 由累计已结算 + 待结算相加而成
     */
    @ApiModelProperty("累计预估收益金额")
    private BigDecimal estimateCash;

    @ApiModelProperty("未结算金额")
    private BigDecimal noSettlementCash;

    @ApiModelProperty("其他收益-现金")
    private BigDecimal otherCash;

    @ApiModelProperty("开卡收益-现金")
    private BigDecimal inviteVipCash;

    @ApiModelProperty("购物收益-现金")
    private BigDecimal rebateCash;

    @ApiModelProperty("累计已结算金额")
    private BigDecimal settledCash;

    @ApiModelProperty("累计已节省金额")
    private BigDecimal saveCash;

    @ApiModelProperty("直卖收益")
    private BigDecimal directSellEarnings;

    @ApiModelProperty("团队收益")
    private BigDecimal teamEarnings;

    @ApiModelProperty("待升级收益，中达人特有")
    private BigDecimal waitUpgradeEarnings;
}
