package com.bxm.localnews.user.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@ApiModel(description = "用户成功邀请人信息")
@Data
@Builder
public class UserInviteDTO {

    @Tolerate
    public UserInviteDTO() {
    }

    @ApiModelProperty("被邀请人用户ID")
    private Long inviteUserId;

    @ApiModelProperty("邀请人用户昵称")
    private String inviteNickName;

    @ApiModelProperty("邀请人用户头像")
    private String inviteHeadImg;

    @ApiModelProperty("邀请日期(已格式化yyyy-MM-dd，用字符类型接收)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date inviteDate;

    @ApiModelProperty("是否开通VIP，true表示已开通")
    private Boolean activeVip;

    @ApiModelProperty("邀请开通的渠道对应的标题（如新闻标题）")
    private String relationTitle;
}
