package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author: gengyy
 * @create: 2020-10-23 13:38
 */
@Data
@ApiModel(description = "马甲号登录成功后的元数据显示")
public class UserVirtualLoginMetaDTO {
    @ApiModelProperty("登录状态编码，512：用户需要进行手机号码绑定")
    private int code;

    @ApiModelProperty("登录的用户信息")
    private UserInfoDTO user;

    @ApiModelProperty("是否首次登录")
    private boolean isFirstLogin;

    @ApiModelProperty("马甲号管理员ID")
    private Long virtualAdminId;

    @ApiModelProperty("是否是马甲号")
    private Boolean isVirtualUser;

    public UserVirtualLoginMetaDTO() {
    }


    public UserVirtualLoginMetaDTO(UserInfoDTO user) {
        this.user = user;
    }

    public UserVirtualLoginMetaDTO(int code, UserInfoDTO user, boolean isFirstLogin) {
        this.code = code;
        this.user = user;
        this.isFirstLogin = isFirstLogin;
    }


    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public UserInfoDTO getUser() {
        return this.user;
    }

    public void setUser(UserInfoDTO user) {
        this.user = user;
    }

    public boolean getIsFirstLogin() {
        return this.isFirstLogin;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.isFirstLogin = firstLogin;
    }
}
