package com.bxm.localnews.user.dto.h5;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

@ApiModel(description = "用户客户端版本信息")
@Data
@Builder
@EqualsAndHashCode(callSuper = true)
public class ClientVersionDto extends BaseBean {

    @Tolerate
    public ClientVersionDto() {
    }

    @ApiModelProperty("用户的客户端版本信息")
    private String version;

    @ApiModelProperty("请求方与目标客户端版本比对结果，-1表示小于对方，0表示版本一致，1表示高于对方")
    private int compareResult;

    @ApiModelProperty("客户端平台")
    private int platform;
}
