package com.bxm.localnews.user.dto.h5;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

@ApiModel(description = "公开的用户信息，注意信息隐私")
@Data
@Builder
@EqualsAndHashCode(callSuper = true)
public class PublicUserInfoDto extends BaseBean {

    @Tolerate
    public PublicUserInfoDto() {
    }

    @ApiModelProperty("请求用户ID")
    private Long userId;

    @ApiModelProperty("用户是否为已注册用户,true表示已注册，false表示未注册或不存在的用户")
    private Boolean regUser = false;
}
