package com.bxm.localnews.user.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(description = "本地人推荐传参实体")
@Data
public class NativeParam extends PageParam {

    @ApiModelProperty("筛选（可选）->性别 0：全部  1：男  2：女 不传则视为全部")
    private Byte sex;

    @ApiModelProperty("筛选（可选）->最小年龄")
    private Byte minAge;

    @ApiModelProperty("筛选（可选）->最大年龄")
    private Byte maxAge;

    @ApiModelProperty("筛选（可选）->所属行业")
    private String industryId;

    @ApiModelProperty(value = "当前定位城市地区编码,直接根据高德SDK得到的地区编码，应该是6位的吧",required = true)
    private String currentAreaCode;

    @ApiModelProperty(value = "纬度",required = true)
    private String lat;

    @ApiModelProperty(value = "经度",required = true)
    private String lon;

    @ApiModelProperty(value = "动作参数(2上划,1下拉) 默认为下拉")
    @NotNull
    private Integer actionType;

    @ApiModelProperty(value = "推荐类型， NORMAL：普通的本地人推荐  FILTER：筛选推荐 OTHER：其他推荐   备注：" +
            "NORMAL：平常在xx人栏目得到的列表 下拉、上划都传NORMAL" +
            "FILTER：点筛选之后得到的列表，（注意）有数据的情况：下拉、上划都传FILTER" +
            "OTHER：如果点筛选之后，没有命中数据，则会出现<其他推荐>栏目，这时候（注意） 下拉则传FILTER，上划则传OTHER ",required = true)
    @NotBlank
    private String recommendCategory;

}
