package com.bxm.localnews.user.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
public class NewbieGuideParam {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称")
    @NotBlank
    private String nickname;

    @ApiModelProperty("头像地址")
    @NotBlank
    private String headImg;

    @ApiModelProperty("性别：0:保密；1:男 ;2:女")
    private Byte sex;

    @ApiModelProperty("生日(精确到日) 格式：yyyy-mm-dd")
    private Date birthday;

}
