package com.bxm.localnews.user.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author: gengyy
 * @create: 2020-10-23 09:32
 */
@Data
@ApiModel("马甲号管理新增马甲号请求参数")
public class UserVirtualAddParam {

    @ApiModelProperty(value = "当前登录用户id（可能是管理员也可能是马甲用户）", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "要绑定的马甲号id", required = true)
    @NotNull(message = "马甲号id不能为空")
    private Long virtualId;

    @ApiModelProperty(value = "马甲号管理员id,以马甲号切换登陆返回的virtualAdminId为主，无则不传")
    private Long virtualAdminId;
}
