package com.bxm.localnews.user.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author: gengyy
 * @create: 2020-10-23 09:33
 */
@Data
@ApiModel("马甲号切换登陆请求参数")
public class UserVirtualLoginParam extends BasicParam {

    @ApiModelProperty(value = "当前登录用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long currentUserId;

    @ApiModelProperty(value = "要切换的用户id", required = true)
    @NotNull(message = "马甲号id不能为空")
    private Long targetUserId;

    @ApiModelProperty(value = "马甲号管理员id,以马甲号切换登陆返回的virtualAdminId为主，无则不传")
    private Long virtualAdminId;

    @ApiModelProperty(value = "登陆账号的Ip", hidden = true)
    private String ip;
}
