package com.bxm.localnews.user.param;

import com.bxm.localnews.mq.common.param.UserSearchPageParam;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author: gengyy
 * @create: 2020-10-22 19:42
 */
@Data
@ApiModel("马甲号管理访问请求参数")
public class UserVirtualParam extends PageParam {

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty("马甲号昵称")
    private String virtualNickName;

    @ApiModelProperty("马甲号管理员ID,以马甲号切换登陆返回的virtualAdminId为主，无则不传")
    private Long virtualAdminId;
}
