package com.bxm.localnews.user.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "登录用户传参实体：情景[手机号密码登录][忘记密码][第三方登录][h5微信授权登录]")
@Data
public class LoginParam {

    @ApiModelProperty("登录标识,如果是[手机号密码登录][忘记密码][h5微信授权登录]则传递手机号码，如果是[第三方登录]则传递第三方登录标识(unionId) 必传")
    private String loginName;

    @ApiModelProperty("登录类型,1:手机号、密码登录，2：QQ登录，3：微信登录，4：微博登录 必传")
    private Byte type;

    @ApiModelProperty(value = "手机号码，[手机号密码登录][忘记密码][h5微信授权登录]必传", hidden = true)
    private String phone;

    @ApiModelProperty(value = "手机验证码，[忘记密码]必传", hidden = true)
    private String code;

    @ApiModelProperty(value = "登录密码，[手机号密码登录][忘记密码][h5微信授权登录]必传", hidden = true)
    private String password;

    @ApiModelProperty("用户头像路径[第三方登录][h5微信授权登录]非必要")
    private String headImg;

    @ApiModelProperty("用户昵称[第三方登录][h5微信授权登录]非必要")
    private String nickname;

    @ApiModelProperty(value = "邀请码 非必要", hidden = true)
    private Long inviteCode;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("如果当前登录请求属于忘记密码并登录则设置为true，否则设为false 必传")
    private Boolean resetPwd;

    @ApiModelProperty("微信的openId [h5微信授权登录]非必要")
    private String openId;

    @ApiModelProperty("微信的unionId [h5微信授权登录]非必要")
    private String unionId;

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID 有则必传")
    private Long id;

    @ApiModelProperty("手机型号")
    private String phonemodel;

    @ApiModelProperty("操作系统版本")
    private String operatingSystem;

    @ApiModelProperty("性别：0:未知; 1:男; 2:女")
    private String sex;
}