package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 具体每一种账号属性的详细解释可以到{@link com.bxm.localnews.user.enums.AccountActionEnum}去看
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户账户信息")
@Data
public class UserAccount extends BaseBean implements IUserIdSharding {

    private static final long serialVersionUID = 3986293313346332549L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("账号状态")
    private Byte state;

    @ApiModelProperty("可用金币余额")
    private Integer usableGold;

    @ApiModelProperty("临时金币余额")
    private Integer tempGold;

    @ApiModelProperty("金币总数")
    private Integer totalGold;

    @ApiModelProperty("消费金币总数")
    private Integer consumeGold;

    /**
     * 当前可用于提现的金额
     */
    @ApiModelProperty("可提现(现金金额)金额")
    private BigDecimal drawableCash;

    /**
     * 所有收入金额的汇总,乱七八糟的收入都有
     */
    @ApiModelProperty("总收入金额")
    private BigDecimal totalCash;

    /**
     * 在一定的时间后会过期的金额
     */
    @ApiModelProperty("临时现金收入")
    private BigDecimal tempCash;

    /**
     * 固化了的现金收入，但是需要一定的激活条件才可以变成可提现金额
     */
    @ApiModelProperty("永久现金收入")
    private BigDecimal stabilizeCash;

    /**
     * 提现审核通过的金额
     */
    @ApiModelProperty("已提现总金额")
    private BigDecimal withdrawalCash;

    /**
     * 提现中的金额
     */
    @ApiModelProperty("当前处于提现待审核状态的金额")
    private BigDecimal withdrawalOfCash;

    /**
     * 用户提现过的钱和当前可提现的钱
     */
    @ApiModelProperty("累计已结算金额")
    private BigDecimal settledCash;

    /**
     * 通过淘客购买的返佣金额，还未结算，可能会退款
     */
    @ApiModelProperty("未结算金额")
    private BigDecimal noSettlementCash;

    /**
     * 购物返佣，不论是否结算
     */
    @ApiModelProperty("购物返佣金额")
    private BigDecimal rebateCash;

    /**
     * 邀请他人开通VIP（付费）后返佣的金额
     */
    @ApiModelProperty("开卡收益金额")
    private BigDecimal inviteVipCash;

    /**
     * 排除购物、开卡收益后的其他收益
     */
    @ApiModelProperty("其他收入金额")
    private BigDecimal otherCash;

    /**
     * 用户省钱金额，拉取到订单就会增加省钱金额
     */
    @ApiModelProperty("用户省钱金额")
    private BigDecimal saveCash;

    @ApiModelProperty(value = "最后变更时间", hidden = true)
    @JsonIgnore
    private Date modifyTime;

    @ApiModelProperty(value = "账号创建时间", hidden = true)
    @JsonIgnore
    private Date createTime;

    @ApiModelProperty(value = "当前操作的版本号，乐观锁控制使用", hidden = true)
    @JsonIgnore
    private Integer version;

    @ApiModelProperty("直卖收益")
    private BigDecimal directSellEarnings;

    @ApiModelProperty("团队收益")
    private BigDecimal teamEarnings;

    @ApiModelProperty("待升级收益，中达人特有")
    private BigDecimal waitUpgradeEarnings;

    public UserAccount() {
    }

    /**
     * 初始用户资金账户
     *
     * @param userId 账号对应的用户ID
     */
    public UserAccount(Long userId) {
        this.userId = userId;
        this.state = AppConst.STATE_USE;
        Integer zeroGold = 0;
        this.usableGold = zeroGold;
        this.tempGold = zeroGold;
        this.consumeGold = zeroGold;
        this.totalGold = zeroGold;

        BigDecimal zeroCash = BigDecimal.ZERO;
        this.drawableCash = zeroCash;
        this.totalCash = zeroCash;
        this.tempCash = zeroCash;
        this.stabilizeCash = zeroCash;
        this.withdrawalCash = zeroCash;
        this.saveCash = zeroCash;
        Date now = new Date();
        this.modifyTime = now;
        this.createTime = now;
    }
}
