package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * a_user_earnings
 *
 * @author lowi
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户收益流水信息表")
@Data
public class UserEarnings extends BaseBean implements IUserIdSharding {
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 收益类型的总类型--总类型ps淘宝返佣
     */
    private Integer type;

    /**
     * 收益类型--细分类型ps淘宝自购，淘宝返佣，淘宝团队
     */
    private Integer earningsType;

    /**
     * 收益标题
     */
    private String earningsTitle;

    /**
     * 收益类型不同，代表不同类型的id
     */
    private Long relationId;

    /**
     * 收益类型的图片
     */
    private String img;

    private String orderNo;

    private Date orderTime;

    /**
     * 佣金
     */
    private BigDecimal commission;

    /**
     * 状态   1 待核销 2 已结算 3 待升级 4 已失效
     */
    private Integer status;

    /**
     * 是否是团队收益 0 不是 1是
     */
    private Integer isTeamEarnings;

    /**
     * 购买的用户id
     */
    private Long sellUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

}