package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.model.dto.UserSaveCashDTO;
import com.bxm.localnews.user.vo.Tuple;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户统计信息相关语句
 *
 * @author liujia
 * @date 2020-08-07 13:49
 **/
@Mapper
public interface UserCountMapper {

    /**
     * 查询各个地区的总人数
     *
     * @return 地区人数汇总信息
     */
    List<Tuple> queryUserTotal();

    /**
     * 查询各个地区的VIP总人数信息
     *
     * @return 各地区的VIP总人数信息汇总
     */
    List<Tuple> queryVipTotal();

    /**
     * 遍历查询账号里面省钱金额不为0的用户，并进行手动分页
     *
     * @param tableIndex 账号表下标索引
     * @param startNum   分页查询起始位置
     * @param limit      分页查询数量
     * @return 分页查询结果
     */
    List<UserSaveCashDTO> querySaveCashByPage(@Param("tableIndex") Integer tableIndex,
                                              @Param("startNum") Integer startNum,
                                              @Param("limit") Integer limit);
}
