package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.vo.UserVip;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 *
 */
@Mapper
public interface UserVipMapper {
    /**
     * 用户id获取用户信息
     *
     * @param userId
     * @return
     */
    UserVip selectByUserId(@Param("userId") Long userId);

    /**
     * vip信息新增
     *
     * @param userVip
     * @return
     */
    int insert(UserVip userVip);


    /**
     * 批量获取状态是正常的，小于expiredDate的会员信息
     * 仅返回ID和userId
     *
     * @param status      会员卡状态
     * @param expiredDate 过期日期
     * @return
     */
    List<UserVip> getUserVipList(@Param("status") Integer status, @Param("expiredDate") Date expiredDate);

    /**
     * 批量更新会员信息
     *
     * @param status  更新的状态
     * @param userIds 用户的id集合
     * @return
     */
    int updateBatchStatusByUid(@Param("status") Integer status, @Param("userIds") List<Long> userIds);

    /**
     * VIP续约
     *
     * @param userVip VIP信息
     * @return 操作结果
     */
    int vipRenew(UserVip userVip);

    /**
     * 更新VIP卡号
     *
     * @param userId 用户ID
     * @param cardNo 卡号
     * @return 更新结果
     */
    int updateCardNo(@Param("userId") Long userId, @Param("cardNo") String cardNo);
}