package com.bxm.localnews.user.domain;

import com.bxm.localnews.user.dto.UserInfoDTO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface VirtualUserMapper {

    /**
     * 查询随机数量的马甲号用户
     * 排除官方号
     * @param num
     * @return
     */
    List<UserInfoDTO> getVirtualUserList(@Param("num") Integer num);

    /**
     * 根据地区和类型查询随机数量的马甲号用户
     * @param num 数量
     * @param types 类型
     * @param areaCode 地区
     * @return
     */
    List<UserInfoDTO> getVirtualUserListNew(@Param("num") Integer num,@Param("types") List<Integer> types,@Param
            ("areaCode") String areaCode);

    /**
     * 查询随机数量的马甲号用户,只取id
     * 排除官方号
     * @param num
     * @return
     */
    List<Long> getRandomVirtualUserIdList(@Param("num") Integer num);

    /**
     * 根据id获取马甲号类型
     * @param id
     * @return
     */
    Byte getVirtualUserType(@Param("id") Long id);

}
