package com.bxm.localnews.user.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(description = "账户金额参数")
public class AccountCashParam extends BaseBean implements IUserIdSharding {

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "金额类型", required = true)
    private String cashType;

    @ApiModelProperty(value = "是否增加累计", required = true)
    private Boolean isAddTotal;

    @ApiModelProperty(value = "金额，可为负值", required = true)
    private BigDecimal cash;

    @ApiModelProperty(value = "业务id", required = true)
    private Long relationId;

    @ApiModelProperty(value = "流水类型", required = true)
    private String cashFlowType;

    @ApiModelProperty(value = "转换类型", required = true)
    private String convertType;

    @ApiModelProperty(value = "邀请途径")
    private String inviteType;

    @ApiModelProperty(value = "受邀人昵称")
    private String invitedUserName;

    public AccountCashParam() {
    }

    public AccountCashParam(Long userId, String cashType, Boolean isAddTotal, BigDecimal cash, Long relationId,
                            String cashFlowType, String convertType) {
        this.userId = userId;
        this.cashType = cashType;
        this.isAddTotal = isAddTotal;
        this.cash = cash;
        this.relationId = relationId;
        this.cashFlowType = cashFlowType;
        this.convertType = convertType;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCashType() {
        return cashType;
    }

    public void setCashType(String cashType) {
        this.cashType = cashType;
    }

    public Boolean getAddTotal() {
        return isAddTotal;
    }

    public void setAddTotal(Boolean addTotal) {
        isAddTotal = addTotal;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getCashFlowType() {
        return cashFlowType;
    }

    public void setCashFlowType(String cashFlowType) {
        this.cashFlowType = cashFlowType;
    }

    public String getConvertType() {
        return convertType;
    }

    public void setConvertType(String convertType) {
        this.convertType = convertType;
    }

    public String getInviteType() {
        return inviteType;
    }

    public void setInviteType(String inviteType) {
        this.inviteType = inviteType;
    }

    public String getInvitedUserName() {
        return invitedUserName;
    }

    public void setInvitedUserName(String invitedUserName) {
        this.invitedUserName = invitedUserName;
    }
}
