/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.param;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import lombok.Data;
import lombok.ToString;

/**
 * 激活用户VIP参数
 *
 * @author : jieli.xu
 * @date 2020/5/14 16:57
 */
@Data
@ToString
public class ActivationUserVipParam extends BasicParam {
    /**
     * 激活方式:默认是激活码
     */
    private ActivationVipEnum activationVipEnum = ActivationVipEnum.ACTIVATION_CODE;

    /**
     * 订单id:自费必传
     */
    private Long orderId;

    /**
     * 充值卡类型id：自费必传
     */
    private String vipCardId;

    /**
     * 进行激活动作的用户id：必传
     */
    private Long userId;

    /**
     * 用户昵称：不传
     */
    private String userName;

    /**
     * 激活码，如果是通过激活码激活则必须提供
     */
    private String code;

    /**
     * 平台，默认是安卓
     */
    private Integer platformEnum = PlatformEnum.ANDROID.getCode();

    /**
     * 渠道：前台给什么就是什么，不做修改，后台直接展示
     */
    private String channel;

    /**
     * 师傅的id：不传
     */
    private Long masterId;

    /**
     * 激活码对应的用户ID
     */
    private Long codeUserId;

    /**
     * VIP卡的开通时长（根据不同的开卡方式有所区分）
     * 非初始参数，在激活VIP流程中填充
     */
    private Integer duration;
}
