package com.bxm.localnews.user.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhaoyadong 2019/3/5 17:28
 * @desc
 */
@ApiModel(description = "创建用户传入参数")
@Data
public class TempUserParam {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("邀请人用户id")
    private Long inviteUserId;

    @ApiModelProperty("邀请途径,2.6.0新增->个人主页：PERSONAL_HOMEPAGE，从个人主页H5页面下载app")
    private String inviteType;

    @ApiModelProperty("用户对应类型的微信openId：微信公众号、微信小程序")
    private String openId;

    @ApiModelProperty("用户在微信开放平台下唯一的unionId")
    private String unionId;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户性别")
    private Byte sex;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("注册ip")
    private String regIp;

    @ApiModelProperty("平台信息 1：安卓 2：IOS 3：H5")
    private String platform;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("注册关联id")
    private Long relationId;

    @ApiModelProperty("是否通过任务邀请，小程序特有，只有通过任务邀请的才给奖励")
    private Boolean taskInvited = false;

    @ApiModelProperty("地区编码")
    private String locationCode;

    @ApiModelProperty("地区名称")
    private String locationName;
}
