package com.bxm.localnews.user.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 视频举报传参
 *
 * @author
 */
@ApiModel(description = "用户举报传参")
@Data
public class UserInformParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("被举报人id")
    private Long informUserId;

    @ApiModelProperty("举报人")
    private Long userId;

    @ApiModelProperty("举报内容")
    private String remark;

    @ApiModelProperty("举报标签(与新闻一样)")
    private String label;

}