package com.bxm.localnews.user.vo;

import com.bxm.localnews.user.dto.UserInfoDTO;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "登录成功后的元数据显示")
public class LoginMeta {

    @ApiModelProperty("登录状态编码，512：用户需要进行手机号码绑定")
    private int code;

    @ApiModelProperty("登录的用户信息")
    private UserInfoDTO user;

    @ApiModelProperty("是否首次登录")
    private boolean isFirstLogin;

    public LoginMeta() {
    }

    public LoginMeta(UserInfoDTO user, boolean isFirstLogin) {
        this.user = user;
        this.isFirstLogin = isFirstLogin;
    }

    public LoginMeta(UserInfoDTO user) {
        this.user = user;
    }

    public LoginMeta(int code, UserInfoDTO user, boolean isFirstLogin) {
        this.code = code;
        this.user = user;
        this.isFirstLogin = isFirstLogin;
    }


    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public UserInfoDTO getUser() {
        return this.user;
    }

    public void setUser(UserInfoDTO user) {
        this.user = user;
    }

    public boolean getIsFirstLogin() {
        return this.isFirstLogin;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.isFirstLogin = firstLogin;
    }

}
