package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.vo.IUserIdSharding;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_user_vip
 *
 * @author
 */
@Data
public class UserVip implements Serializable, IUserIdSharding {
    /**
     * 主键
     */
    private Long id;

    /**
     * 对应的用户ID
     */
    private Long userId;

    /**
     * 过期日期
     */
    private Date expiredDate;

    /**
     * VIP等级
     */
    private String level;

    /**
     * VIP权益（每一位表示一种权益）
     */
    private String rights;

    /**
     * VIP开通方式（0:自费、1:激活）
     */
    private Integer type;

    /**
     * 是否有效，1：有效，0：已过期，2：待激活
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 开卡渠道：ios/android/weixin/entitycard
     */
    private String channel;

    /**
     * VIP卡号
     */
    private String card;

    /**
     * 当前用户的激活码，来自于激活码对应的表
     */
    private String activeCode;

    /**
     * 激活码剩余可用次数
     */
    private Integer leftOpenNum;

    /**
     * 当前VIP是否处于可用状态
     */
    private Boolean usable;

    public UserVip() {
    }

    public UserVip(Long userId, Integer status) {
        this.userId = userId;
        this.status = status;
    }
}