package com.bxm.localnews.user.vo.vip;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author
 */
@Data
public class UserActiveCodeBean implements Serializable {
    private Long id;

    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 激活码
     */
    private String activeCode;

    /**
     * 激活码所属用户ID
     */
    private Long userId;

    /**
     * 卡类型（0：渠道卡，1：购卡激活码，2：二次激活码）
     */
    private Integer cardType;

    /**
     * 卡状态（0:不可用，1：可用）
     */
    private Integer status;

    /**
     * 可用次数
     */
    private Integer maxTimes;

    /**
     * 已激活次数
     */
    private Integer activeTimes;

    /**
     * 卡创建时间
     */
    private Date createTime;

    /**
     * 信息变更时间
     */
    private Date modifyTime;

    /**
     * 地区编码（卡所属地区）
     */
    private String areaCode;

    /**
     * 数据版本
     */
    private Integer version;

    private static final long serialVersionUID = 1L;
}