package com.bxm.localnews.user.controller;

import java.math.BigDecimal;

import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.service.AccountService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/15 10:20
 * @desc
 */
@Api(tags = "9-96 [内部接口]金币相关接口")
@RequestMapping("facade/account")
@RestController
@Slf4j
public class AccoutFacadeController {

    @Autowired
    private AccountService accountService;

    @ApiOperation(value = "9-96-01 扣除用户金币信息", notes = "扣除用户金币", httpMethod = "POST")
    @PostMapping("/balance/deduct")
    public ResponseEntity<Boolean> deductUserBalance(@RequestBody DeductPointParam deductPointParam) {
        return ResponseEntity.ok(accountService.deductUserGold(deductPointParam));
    }

    @ApiOperation(value = "9-96-02 确认扣除用户金币", notes = "确认扣除用户金币", httpMethod = "POST")
    @PostMapping("/balance/confirm")
    public void deductConfirmUserBalance(@RequestBody DeductPointParam deductPointParam) {
        accountService.deductConfirmUserGold(deductPointParam);
    }

    @ApiOperation(value = "9-96-03 添加用户金币", notes = "添加用户金币", httpMethod = "POST")
    @PostMapping("/balance/add")
    public void addUserBalance(@RequestBody DeductPointParam deductPointParam) {
        accountService.addUserGold(deductPointParam);
    }

    @ApiOperation(value = "9-96-04 获取用户金币信息", notes = "获取用户金币信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @GetMapping("/balance")
    public ResponseEntity<BigDecimal> selectUsableGoldByUserId(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(accountService.selectUsableGoldByUserId(userId));
    }
}
