package com.bxm.localnews.user.controller;

import java.math.BigDecimal;

import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.service.GoldFlowService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/6 20:07
 * @desc
 */
@Api(tags = "9-94 [内部接口]用户账户相关接口")
@RequestMapping("facade/user/account")
@RestController
@Slf4j
public class UserAccountFacadeController {

    @Autowired
    private UserAccountService userAccountService;

    @Autowired
    private GoldFlowService goldFlowService;

    @ApiOperation(value = "9-94-1 获取个人中心钱包和金币信息", httpMethod = "GET", notes = "获取用户对应的金币余额和现金余额")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/my")
    public ResponseEntity<UserCashGoldDTO> getUserCashGold(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(this.userAccountService.getUserCashGold(userId));
    }

    @ApiOperation(value = "9-94-2 修改账户金额", httpMethod = "POST", notes = "修改账户金额，记录流水")
    @PostMapping("/addCash")
    public ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param) {
        return ResponseEntity.ok(this.userAccountService.addCash(param));
    }

    @ApiOperation(value = "9-94-3 获取账户可提现金额", httpMethod = "GET", notes = "获取账户可提现金额")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/able")
    public ResponseEntity<BigDecimal> getUserDrawablelCash(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(this.userAccountService.getUserDrawablelCash(userId));
    }

    @ApiOperation(value = "9-94-4 账户金额转化", httpMethod = "POST", notes = "账户金额转化，记录流水")
    @PostMapping("/transferCash")
    public ResponseEntity<Boolean> transferCash(@RequestBody AccountCashParam param) {
        return ResponseEntity.ok(this.userAccountService.transferCash(param));
    }

    @ApiOperation(value = "9-94-5 针对于受邀人赏金提现", httpMethod = "POST", notes = "账户金额转化，记录流水")
    @PostMapping("/update")
    public ResponseEntity<Message> updateUserWithdrawInfo(@RequestParam("userId") Long userId,
                                                          @RequestParam("amount") BigDecimal amount,
                                                          @RequestParam("withdrawState") Byte withdrawState) {
        return ResponseEntity.ok(this.userAccountService.updateUserWithdrawInfo(userId, amount, withdrawState));
    }


    @ApiOperation(value = "9-94-6 获取用户的现金累计金额", httpMethod = "GET", notes = "账户金额")
    @GetMapping("/totalCash")
    public ResponseEntity<BigDecimal> getUserTotalCash(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(this.userAccountService.getUserTotalCash(userId));
    }

    @ApiOperation(value = "9-94-7 获取用户的可用金币余额", httpMethod = "GET", notes = "账户可用金币余额")
    @GetMapping("/usableGold")
    public ResponseEntity<Integer> getUserUsableGold(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(this.userAccountService.getUserUsableGold(userId));
    }

    @ApiOperation(value = "9-94-8 修改账户金币", httpMethod = "POST", notes = "修改账户金币，记录流水")
    @PostMapping("/addGold")
    public ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param) {
        return ResponseEntity.ok(this.userAccountService.addGold(param));
    }

    @ApiOperation(value = "9-94-9 根据帖子id获取流水金币数", httpMethod = "GET", notes = "根据帖子id获取流水金币数")
    @GetMapping("/countGoldByPostId")
    public ResponseEntity<Integer> countGoldByPostId(@RequestParam("postId") Long postId, @RequestParam("userId") Long userId) {
        return ResponseEntity.ok(this.goldFlowService.countGoldByPostId(postId, userId));
    }
}
