/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-93 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u4fe1\u606f\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/user"})
@RestController
public class UserFacadeController {
    private static final Logger log = LoggerFactory.getLogger(UserFacadeController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private UserBaseInfoService userBaseInfoService;

    @ApiOperation(value="9-93-01 \u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"/info"})
    public ResponseEntity<UserInfoDTO> selectUserFromCache(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userService.getUserFromRedisDB(userId.longValue()));
    }

    @ApiOperation(value="9-93-02 \u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5934\u50cf", notes="\u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5934\u50cf", httpMethod="GET")
    @GetMapping(value={"/headimg"})
    public ResponseEntity<String> getDefaultHeadImgUrl() {
        return ResponseEntity.ok((Object)this.userService.getDefaultHeadImgUrl());
    }

    @ApiOperation(value="9-93-03 \u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/detail"})
    public ResponseEntity<User> selectByPrimaryKey(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userService.selectByPrimaryKey(userId));
    }

    @ApiOperation(value="9-93-04 \u5224\u65adunionId\u662f\u5426\u88ab\u4f7f\u7528", notes="\u5224\u65adunionId\u662f\u5426\u88ab\u4f7f\u7528")
    @RequestMapping(value={"/unionId"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam(value="unionId") String unionId) {
        return ResponseEntity.ok((Object)this.userService.checkUnionIdIsUser(unionId));
    }

    @ApiOperation(value="9-93-05 \u521b\u5efa\u7528\u6237", notes="\u901a\u8fc7\u5fae\u4fe1\u76f8\u5173\u767b\u9646\u521b\u5efa\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/create"})
    public ResponseEntity<Message> createUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok((Object)this.userService.createUser(tempUserParam));
    }

    @ApiOperation(value="9-93-06 \u83b7\u53d6\u4e2a\u4eba\u76f8\u5173\u4fe1\u606f", notes="\u5305\u542b\u59d3\u540d\u3001\u5934\u50cf\u3001\u91d1\u5e01\u3001\u7b7e\u5230\u4fe1\u606f\u3001\u9080\u8bf7\u4eba\u6570")
    @GetMapping(value={"/base/info"})
    public ResponseEntity<UserBaseInfoDTO> getUserBaseInfo(Long userId, int platform) {
        return ResponseEntity.ok((Object)this.userBaseInfoService.getUserInfoForWST(userId, platform));
    }

    @ApiOperation(value="9-93-06 \u7528\u6237\u662f\u5426\u662f\u4e34\u65f6\u7528\u6237", notes="true\uff1a\u8868\u793a\u662f\u4e34\u65f6\u7528\u6237 false\uff1a\u8868\u793a\u662f\u6c38\u4e45\u7528\u6237")
    @GetMapping(value={"/temp"})
    public ResponseEntity<Boolean> isTempUser(Long userId) {
        return ResponseEntity.ok((Object)this.userService.isTempUser(userId));
    }

    @ApiOperation(value="9-93-07 \u7528\u6237\u662f\u5426\u662f\u98ce\u9669\u7528\u6237", notes="true\uff1a\u8868\u793a\u662f\u98ce\u9669\u7528\u6237 false\uff1a\u8868\u793a\u662f\u4e34\u65f6\u7528\u6237")
    @GetMapping(value={"/risk"})
    public ResponseEntity<Boolean> isRiskUser(Long userId) {
        return ResponseEntity.ok((Object)this.userService.isRiskUser(userId));
    }

    @ApiOperation(value="9-93-10 \u5e16\u5b50\u3001\u8bc4\u8bba\u6570\u4fee\u6539", notes="\u5e16\u5b50\u3001\u8bc4\u8bba\u6570\u4fee\u6539, type\uff1a1\u5e16\u5b50+1 2\u5e16\u5b50-1 3\u8bc4\u8bba+1 4\u8bc4\u8bba-1")
    @PostMapping(value={"/addPostReplyNum"})
    public ResponseEntity<Boolean> addPostReplyNum(@RequestParam(value="userId") Long userId, @RequestParam(value="type") Integer type) {
        return ResponseEntity.ok((Object)this.userService.addPostReplyNum(userId, type));
    }

    @ApiOperation(value="9-93-11 \u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u3011", notes="")
    @PostMapping(value={"/update"})
    public ResponseEntity<Message> updateUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok((Object)this.userService.updateUser(tempUserParam));
    }

    @ApiOperation(value="9-93-12 \u83b7\u53d6\u865a\u62df\u7528\u6237", notes="")
    @PostMapping(value={"/getVirtualUserList"})
    public ResponseEntity<List<UserInfoDTO>> getVirtualUserList(@RequestParam(value="num") Integer num) {
        return ResponseEntity.ok((Object)this.userService.getVirtualUserList(num));
    }
}

