/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.auth.enums.RoleCodeEnum;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.param.RemoveAuthCodeParam;
import com.bxm.localnews.user.param.UserAuthCodeParam;
import com.bxm.localnews.user.param.UserAuthResourceParam;
import com.bxm.localnews.user.param.UserRoleParam;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-99 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u6743\u9650\u7f16\u7801\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/user/auth/code"})
@RestController
public class UserAuthCodeFacadeController {
    private static final Logger log = LoggerFactory.getLogger(UserAuthCodeFacadeController.class);
    @Resource
    private UserAuthCodeService userAuthCodeService;

    @ApiOperation(value="9-99-01 \u8bbe\u7f6e\u7528\u6237\u89d2\u8272")
    @PostMapping(value={"/add/role"})
    public ResponseEntity<Boolean> addRole(@RequestBody UserRoleParam param) {
        Message message = this.userAuthCodeService.addRole(param.getUserId(), RoleCodeEnum.valueOf((String)param.getRoleCode()));
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-02 \u79fb\u9664\u7528\u6237\u89d2\u8272")
    @PostMapping(value={"/remove/role"})
    public ResponseEntity<Boolean> removeRole(@RequestBody UserRoleParam param) {
        Message message = this.userAuthCodeService.removeRole(param.getUserId(), RoleCodeEnum.valueOf((String)param.getRoleCode()));
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-3 \u6dfb\u52a0\u7528\u6237\u6743\u9650")
    @PostMapping(value={"/add/auth"})
    public ResponseEntity<Boolean> addAuth(@RequestBody UserAuthCodeParam authCodeParam) {
        AuthCodeEnum authCode = AuthCodeEnum.getByIndex((Integer)authCodeParam.getAuthCode());
        Message message = this.userAuthCodeService.addAuthCode(authCodeParam.getUserId(), authCode);
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-4 \u6dfb\u52a0\u7528\u6237\u8d44\u6e90\u6743\u9650")
    @PostMapping(value={"/add/resource"})
    public ResponseEntity<Boolean> addResource(@RequestBody UserAuthResourceParam param) {
        AuthCodeEnum authCode = AuthCodeEnum.getByIndex((Integer)param.getAuthCode());
        Message message = this.userAuthCodeService.addResource(param.getUserId(), authCode, param.getResourceId());
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-5 \u79fb\u9664\u7528\u6237\u6743\u9650")
    @PostMapping(value={"/del/auth"})
    public ResponseEntity<Boolean> delAuth(@RequestBody UserAuthCodeParam authCodeParam) {
        AuthCodeEnum authCode = AuthCodeEnum.getByIndex((Integer)authCodeParam.getAuthCode());
        Message message = this.userAuthCodeService.removeAuthCode(authCodeParam.getUserId(), authCode);
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-5 \u6dfb\u52a0\u79fb\u9664\u7528\u6237\u6743\u9650\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/add/remove/auth/task"})
    public ResponseEntity<Boolean> addRemoveTask(@RequestBody RemoveAuthCodeParam param) {
        Message message = this.userAuthCodeService.addRemoveAuthCodeTask(param);
        return ResponseEntity.ok((Object)message.isSuccess());
    }

    @ApiOperation(value="9-99-6 \u79fb\u9664\u7528\u6237\u6743\u9650\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"remove/auth/task"})
    public ResponseEntity<Boolean> addRemoveTask(@RequestParam Long userId) {
        Message message = this.userAuthCodeService.removeAuthCodeTask(userId);
        return ResponseEntity.ok((Object)message.isSuccess());
    }
}

