/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.mq.common.param.UserSearchPageParam;
import com.bxm.localnews.user.attribute.DeprecatedService;
import com.bxm.localnews.user.attribute.UserAttributeService;
import com.bxm.localnews.user.attribute.UserFollowService;
import com.bxm.localnews.user.attribute.UserFunsService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.dto.InteractRankInfo;
import com.bxm.localnews.user.dto.UserBaseInfo;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserTbkInfo;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.VipPaymentCallbackParam;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.query.UserQueryService;
import com.bxm.localnews.user.service.BlockUserService;
import com.bxm.localnews.user.support.UserInternalService;
import com.bxm.localnews.user.support.VirtualUserService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserFuns;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-93 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u4fe1\u606f\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/user"})
@RestController
public class UserFacadeController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UserFacadeController.class);
    @Resource
    private UserService userService;
    @Resource
    private UserInternalService userInternalService;
    @Resource
    private UserFollowService userFollowService;
    @Resource
    private UserFunsService userFunsService;
    @Resource
    private UserAttributeService userAttributeService;
    @Resource
    private VirtualUserService virtualUserService;
    @Resource
    private UserProperties userProperties;
    @Resource
    private BlockUserService blockUserService;
    @Resource
    private UserPersonalInfoService userPersonalInfoService;
    @Resource
    private DeprecatedService deprecatedService;
    @Resource
    private UserVipService userVipService;
    @Resource
    private UserQueryService userQueryService;

    @ApiOperation(value="9-93-01 \u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"/info"})
    public ResponseEntity<UserInfoDTO> selectUserFromCache(@RequestParam(value="userId", required=false) Long userId) {
        if (null == userId) {
            this.logger.warn("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)this.userService.getUserCache(userId));
    }

    @ApiOperation(value="9-93-02 \u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5934\u50cf", notes="\u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5934\u50cf", httpMethod="GET")
    @GetMapping(value={"/headimg"})
    public ResponseEntity<String> getDefaultHeadImgUrl() {
        return ResponseEntity.ok((Object)this.userProperties.getDefaultHeadImgUrl());
    }

    @ApiOperation(value="9-93-03 \u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/detail"})
    public ResponseEntity<User> selectByPrimaryKey(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userService.selectByPrimaryKey(userId));
    }

    @ApiOperation(value="9-93-04 \u5224\u65adunionId\u662f\u5426\u88ab\u4f7f\u7528", notes="\u5224\u65adunionId\u662f\u5426\u88ab\u4f7f\u7528")
    @RequestMapping(value={"/unionId"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam(value="unionId") String unionId) {
        return ResponseEntity.ok((Object)this.userService.checkUnionIdIsUser(unionId));
    }

    @ApiOperation(value="9-93-05 \u521b\u5efa\u7528\u6237", notes="\u901a\u8fc7\u5fae\u4fe1\u76f8\u5173\u767b\u9646\u521b\u5efa\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/create"})
    public ResponseEntity<Message> createUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok((Object)this.userService.createTempUser(tempUserParam));
    }

    @ApiOperation(value="9-93-06 [\u6211\u7684]\u83b7\u53d6\u4e2a\u4eba\u76f8\u5173\u4fe1\u606f", notes="\u5305\u542b\u59d3\u540d\u3001\u5934\u50cf\u3001\u91d1\u5e01\u3001\u7b7e\u5230\u4fe1\u606f\u3001\u9080\u8bf7\u4eba\u6570")
    @GetMapping(value={"/base/info"})
    @Deprecated
    public ResponseEntity<UserBaseInfoDTO> getUserBaseInfo(Long userId, int platform) throws BindException {
        this.direct().prop("userId", (Object)userId).notBlank("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseEntity.ok((Object)this.userInternalService.getUserPersonalCenterInfo(userId, platform));
    }

    @ApiOperation(value="9-93-06 \u7528\u6237\u662f\u5426\u662f\u4e34\u65f6\u7528\u6237", notes="true\uff1a\u8868\u793a\u662f\u4e34\u65f6\u7528\u6237 false\uff1a\u8868\u793a\u662f\u6c38\u4e45\u7528\u6237")
    @GetMapping(value={"/temp"})
    public ResponseEntity<Boolean> isTempUser(Long userId) {
        return ResponseEntity.ok((Object)this.userService.isTempUser(userId));
    }

    @ApiOperation(value="9-93-07 \u7528\u6237\u662f\u5426\u662f\u98ce\u9669\u7528\u6237", notes="true\uff1a\u8868\u793a\u662f\u98ce\u9669\u7528\u6237 false\uff1a\u8868\u793a\u662f\u4e34\u65f6\u7528\u6237")
    @GetMapping(value={"/risk"})
    public ResponseEntity<Boolean> isRiskUser(Long userId) {
        return ResponseEntity.ok((Object)this.userService.isRiskUser(userId));
    }

    @ApiOperation(value="9-93-10 \u5e16\u5b50\u3001\u8bc4\u8bba\u6570\u4fee\u6539", notes="\u5e16\u5b50\u3001\u8bc4\u8bba\u6570\u4fee\u6539, type\uff1a1\u5e16\u5b50+1 2\u5e16\u5b50-1 3\u8bc4\u8bba+1 4\u8bc4\u8bba-1")
    @PostMapping(value={"/addPostReplyNum"})
    public ResponseEntity<Boolean> addPostReplyNum(@RequestParam(value="userId") Long userId, @RequestParam(value="type") Integer type) {
        return ResponseEntity.ok((Object)this.userAttributeService.addPostReplyNum(userId, type));
    }

    @ApiOperation(value="9-93-11 \u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u3011")
    @PostMapping(value={"/update"})
    public ResponseEntity<Message> updateUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok((Object)this.userService.updateTempUser(tempUserParam));
    }

    @ApiOperation(value="9-93-12 \u83b7\u53d6\u865a\u62df\u7528\u6237", notes="\u968f\u673a\u83b7\u53d6\u4e00\u5b9a\u91cf\u7684\u865a\u62df\u7528\u6237")
    @PostMapping(value={"/getVirtualUserList"})
    public ResponseEntity<List<UserInfoDTO>> getVirtualUserList(@RequestParam(value="num") Integer num) {
        return ResponseEntity.ok((Object)this.virtualUserService.listVirtualUser(num));
    }

    @ApiOperation(value="9-93-99 \u6839\u636e\u5730\u533a\u548c\u7c7b\u578b\u83b7\u53d6\u865a\u62df\u7528\u6237", notes="\u968f\u673a\u83b7\u53d6\u4e00\u5b9a\u91cf\u7684\u865a\u62df\u7528\u6237")
    @PostMapping(value={"/getVirtualUserListNew"})
    public ResponseEntity<List<UserInfoDTO>> getVirtualUserListNew(@RequestParam(value="num") Integer num, @RequestParam(value="types") List<Integer> types, @RequestParam(value="areaCode", required=false) String areaCode) {
        return ResponseEntity.ok((Object)this.virtualUserService.listVirtualUserNew(num, types, areaCode));
    }

    @ApiOperation(value="9-93-13 \u5168\u91cf\u66f4\u65b0\u7528\u6237\u7684\u70b9\u8d5e\u6570\u91cf", notes="\u5168\u91cf\u66f4\u65b0\u7528\u6237\u7684\u70b9\u8d5e\u6570\u91cf")
    @PostMapping(value={"/updateUserLikeNum"})
    public ResponseEntity<Boolean> updateUserLikeNum() {
        return ResponseEntity.ok((Object)this.userAttributeService.updateUserLikeNum(Long.valueOf(0L)));
    }

    @ApiOperation(value="9-93-14 \u7528\u6237\u70b9\u8d5e\u6570\u66f4\u65b0", notes="\u6839\u636e\u7528\u6237id\u66f4\u65b0\u70b9\u8d5e\u6570")
    @PostMapping(value={"/updateUserLikeNumByUserId"})
    public ResponseEntity<Boolean> updateUserLikeNumByUserId(Long userId) {
        return ResponseEntity.ok((Object)this.userAttributeService.updateUserLikeNumByUserId(userId));
    }

    @ApiOperation(value="9-93-15 \u5224\u65ad\u7528\u6237\u662f\u5426\u5173\u6ce8\u4e86\u5bf9\u65b9")
    @GetMapping(value={"isFollow"})
    public ResponseEntity<Boolean> isFollow(@RequestParam(value="fromUserId") Long fromUserId, @RequestParam(value="toUserId") Long toUserId) {
        return ResponseEntity.ok((Object)this.userFollowService.isFollowed(fromUserId, toUserId));
    }

    @ApiOperation(value="9-93-16 \u6279\u91cf\u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", notes="\u6279\u91cf\u83b7\u53d6\u7528\u6237\u7f13\u5b58\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParam(name="userIds", value="\u7528\u6237id")
    @PostMapping(value={"/batchUserInfo"})
    public ResponseEntity<List<UserInfoDTO>> selectUserFromCache(@RequestBody List<Long> userIds) {
        return ResponseEntity.ok((Object)this.userService.getBatchUserInfo(userIds));
    }

    @ApiOperation(value="9-93-17 \u7edf\u8ba1\u6ce8\u518c\u7528\u6237")
    @GetMapping(value={"/countRegUser"})
    public ResponseEntity<Integer> countRegUser(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        return ResponseEntity.ok((Object)this.userInternalService.countRegUser(startTime, endTime));
    }

    @ApiOperation(value="9-93-18 \u662f\u5426\u662f\u88ab\u62c9\u9ed1\u7684\u7528\u6237", notes="\u662f\u5426\u662f\u88ab\u62c9\u9ed1\u7684\u7528\u6237", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"/limit/block"})
    public ResponseEntity<Boolean> isBlockLimitUser(@RequestParam Long userId) {
        return ResponseEntity.ok((Object)this.blockUserService.isBlockLimitUser(userId));
    }

    @ApiOperation(value="9-93-19 \u662f\u5426\u662f\u88ab\u63a8\u8350\u964d\u6743\u7684\u7528\u6237", notes="\u662f\u5426\u662f\u88ab\u63a8\u8350\u964d\u6743\u7684\u7528\u6237", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"/limit/recommend"})
    public ResponseEntity<Boolean> isRecommendLimitUser(@RequestParam Long userId) {
        return ResponseEntity.ok((Object)this.blockUserService.isRecommendLimitUser(userId));
    }

    @ApiOperation(value="9-93-20 \u68c0\u6d4b\u7528\u6237\u4fe1\u606f\u4e0d\u5b8c\u5584\u5ea6\u662f\u5426\u5c0f\u4e8e2", notes="true\uff1a\u662f  false\uff1a\u4e0d\u662f", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"/personal-info/complete"})
    public ResponseEntity<Boolean> checkInfoComplete(@RequestParam Long userId) {
        return ResponseEntity.ok((Object)this.userPersonalInfoService.checkInfoCompleteStatus(userId));
    }

    @ApiOperation(value="9-93-21 \u540c\u6b65\u7528\u6237\u7684\u5b8c\u5584\u5ea6", notes="", httpMethod="GET")
    @GetMapping(value={"/personal-info/sync"})
    public ResponseEntity checkInfoComplete() {
        this.deprecatedService.updateUserCompleteInfo();
        return ResponseEntity.ok().build();
    }

    @ApiOperation(value="9-93-22 \u662f\u5426\u662f\u6b63\u5e38\u7528\u6237", notes="true\uff1a\u8868\u793a\u662f\u6b63\u5e38\u7528\u6237 false\uff1a\u8868\u793a\u662f\u975e\u6b63\u5e38\u7528\u6237")
    @GetMapping(value={"/normal"})
    public ResponseEntity<Boolean> isNormalUser(@RequestParam Long userId) {
        return ResponseEntity.ok((Object)this.userService.isNormalUser(userId));
    }

    @ApiOperation(value="9-93-23 \u662f\u5426\u5b58\u5728user\u5173\u6ce8\u4e86target\u7684\u5173\u6ce8\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237ID"), @ApiImplicitParam(name="targetUid", value="\u76ee\u6807\u7528\u6237ID")})
    @GetMapping(value={"hasFollowMsg"})
    public ResponseEntity<Boolean> hasFollowMsg(@RequestParam(value="userId") Long userId, @RequestParam(value="targetUid") Long targetUid) {
        return ResponseEntity.ok((Object)this.userFollowService.hasFollowMsg(userId, targetUid));
    }

    @ApiOperation(value="9-93-24 \u6839\u636eid\u83b7\u53d6\u9a6c\u7532\u53f7\u7c7b\u578b")
    @GetMapping(value={"/virtual/type"})
    public ResponseEntity<Byte> hasFollowMsg(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.virtualUserService.getVirtualUserType(userId));
    }

    @ApiOperation(value="9-93-25 \u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userIdList", value="\u7528\u6237id\u5217\u8868")})
    @GetMapping(value={"getUserFuns"})
    public ResponseEntity<List<UserFuns>> getUserFuns(@RequestParam(value="userIdList") List<Long> userIdList) {
        return ResponseEntity.ok((Object)this.userFunsService.getUserFuns(userIdList));
    }

    @ApiOperation(value="9-93-26 \u7528\u6237\u8d2d\u4e70vip\u5361\u6fc0\u6d3bvip")
    @PostMapping(value={"activationVip"})
    public ResponseEntity<Boolean> activationVip(@RequestBody VipPaymentCallbackParam param) {
        return ResponseEntity.ok((Object)this.userVipService.execActivationVipByPay(param));
    }

    @ApiOperation(value="9-93-26 \u6839\u636e\u6dd8\u5ba2relation id \u83b7\u53d6\u7528\u6237\u6dd8\u5ba2\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="relationId", value="\u6dd8\u5ba2relation id")})
    @GetMapping(value={"selectUserFromCacheByRelationId"})
    public ResponseEntity<UserTbkInfo> selectUserFromCacheByRelationId(@RequestParam(value="relationId") String relationId) {
        return ResponseEntity.ok((Object)this.userService.selectUserFromCacheByRelationId(relationId));
    }

    @ApiOperation(value="9-93-27 \u6839\u636euserId \u83b7\u53d6\u7528\u6237\u6dd8\u5ba2\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="userId")})
    @GetMapping(value={"selectUserFromCacheByUserId"})
    public ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userService.selectUserFromCacheByUserId(userId));
    }

    @ApiOperation(value="9-93-28 \u6839\u636euserId/userName \u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u63d0\u4f9b\u7ed9\u540e\u53f0manage\u4f7f\u7528\u7684\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="userId"), @ApiImplicitParam(name="userName", value="userName")})
    @GetMapping(value={"selectUserByIdName"})
    public ResponseEntity<List<UserBaseInfo>> selectUserByIdName(@RequestParam(value="userId") Long userId, @RequestParam(value="userName") String userName) {
        return ResponseEntity.ok((Object)this.userService.selectUserByIdName(userId, userName));
    }

    @ApiOperation(value="9-93-29 \u66f4\u65b0\u6807\u5fd7\u4f4d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="userId"), @ApiImplicitParam(name="judgeMarker", value="\u6807\u5fd7\u4f4d LocalNewsUserJudgeMarkerEnum"), @ApiImplicitParam(name="add", value="true \u589e\u52a0 false \u79fb\u9664")})
    @GetMapping(value={"updateUserJudgeMarker"})
    public ResponseEntity<Boolean> updateUserJudgeMarker(@RequestParam(value="userId") Long userId, @RequestParam(value="judgeMarker") LocalNewsUserJudgeMarkerEnum judgeMarker, @RequestParam(value="add") Boolean add) {
        this.userService.updateUserJudgeMarker(userId, judgeMarker, Objects.equals(add, Boolean.TRUE));
        return ResponseEntity.ok((Object)true);
    }

    @ApiOperation(value="9-93-30 \u83b7\u53d6\u8bc4\u8bba\u6392\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801"), @ApiImplicitParam(name="limitNum", value="\u622a\u53d6\u6392\u884c\u6761\u6570")})
    @GetMapping(value={"interactRankInfo"})
    public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="limitNum") Integer limitNum, @RequestParam(value="userIds") List<Long> userIds) {
        return ResponseEntity.ok((Object)this.userService.getInteractRankInfo(areaCode, limitNum.intValue(), userIds));
    }

    @ApiOperation(value="9-93-31 \u83b7\u53d6\u4e2a\u4eba\u8bc4\u8bba\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="userId")})
    @GetMapping(value={"replyNumForUser"})
    public ResponseEntity<Integer> replyNumForUser(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userService.replyNumForUser(userId));
    }

    @ApiOperation(value="9-93-32 \u901a\u8fc7\u63a8\u9001\u7b56\u7565\u5206\u9875\u68c0\u7d22\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"query/page"})
    public ResponseEntity<PageWarper<Long>> queryByPage(@RequestBody UserSearchPageParam param) {
        return ResponseEntity.ok((Object)this.userQueryService.queryUserByPushParam(param));
    }

    @ApiOperation(value="9-93-33 \u67e5\u8be2\u7528\u6237\u662f\u5426\u662fvip")
    @GetMapping(value={"isVip"})
    public ResponseEntity<Boolean> checkUserIsVip(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userVipService.isVip(userId));
    }
}

