/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.account.GoldFlowService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-94 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u8d26\u6237\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/user/account"})
@RestController
public class UserAccountFacadeController {
    private static final Logger log = LoggerFactory.getLogger(UserAccountFacadeController.class);
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private GoldFlowService goldFlowService;

    @ApiOperation(value="9-94-1 \u83b7\u53d6\u4e2a\u4eba\u4e2d\u5fc3\u94b1\u5305\u548c\u91d1\u5e01\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7684\u91d1\u5e01\u4f59\u989d\u548c\u73b0\u91d1\u4f59\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"/my"})
    public ResponseEntity<UserCashGoldDTO> getUserCashGold(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userAccountService.getUserCashGold(userId));
    }

    @ApiOperation(value="9-94-2 \u4fee\u6539\u8d26\u6237\u91d1\u989d", httpMethod="POST", notes="\u4fee\u6539\u8d26\u6237\u91d1\u989d\uff0c\u8bb0\u5f55\u6d41\u6c34")
    @PostMapping(value={"/addCash"})
    public ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param) {
        return ResponseEntity.ok((Object)this.userAccountService.addCash(param));
    }

    @ApiOperation(value="9-94-3 \u83b7\u53d6\u8d26\u6237\u53ef\u63d0\u73b0\u91d1\u989d", httpMethod="GET", notes="\u83b7\u53d6\u8d26\u6237\u53ef\u63d0\u73b0\u91d1\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"/able"})
    public ResponseEntity<BigDecimal> getUserDrawableCash(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userAccountService.getUserDrawableCash(userId));
    }

    @ApiOperation(value="9-94-4 \u8d26\u6237\u91d1\u989d\u8f6c\u5316", httpMethod="POST", notes="\u8d26\u6237\u91d1\u989d\u8f6c\u5316\uff0c\u8bb0\u5f55\u6d41\u6c34")
    @PostMapping(value={"/transferCash"})
    public ResponseEntity<Boolean> transferCash(@RequestBody AccountCashParam param) {
        return ResponseEntity.ok((Object)this.userAccountService.transferCash(param));
    }

    @ApiOperation(value="9-94-5 \u9488\u5bf9\u4e8e\u53d7\u9080\u4eba\u8d4f\u91d1\u63d0\u73b0", httpMethod="POST", notes="\u8d26\u6237\u91d1\u989d\u8f6c\u5316\uff0c\u8bb0\u5f55\u6d41\u6c34")
    @PostMapping(value={"/update"})
    public ResponseEntity<Message> updateUserWithdrawInfo(@RequestParam(value="userId") Long userId, @RequestParam(value="amount") BigDecimal amount, @RequestParam(value="withdrawState") Byte withdrawState) {
        return ResponseEntity.ok((Object)this.userAccountService.updateUserWithdrawInfo(userId, amount, withdrawState));
    }

    @ApiOperation(value="9-94-6 \u83b7\u53d6\u7528\u6237\u7684\u73b0\u91d1\u7d2f\u8ba1\u91d1\u989d", httpMethod="GET", notes="\u8d26\u6237\u91d1\u989d")
    @GetMapping(value={"/totalCash"})
    public ResponseEntity<BigDecimal> getUserTotalCash(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userAccountService.getUserTotalCash(userId));
    }

    @ApiOperation(value="9-94-7 \u83b7\u53d6\u7528\u6237\u7684\u53ef\u7528\u91d1\u5e01\u4f59\u989d", httpMethod="GET", notes="\u8d26\u6237\u53ef\u7528\u91d1\u5e01\u4f59\u989d")
    @GetMapping(value={"/usableGold"})
    public ResponseEntity<Integer> getUserUsableGold(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userAccountService.getUserUsableGold(userId));
    }

    @ApiOperation(value="9-94-8 \u4fee\u6539\u8d26\u6237\u91d1\u5e01", httpMethod="POST", notes="\u4fee\u6539\u8d26\u6237\u91d1\u5e01\uff0c\u8bb0\u5f55\u6d41\u6c34")
    @PostMapping(value={"/addGold"})
    public ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param) {
        return ResponseEntity.ok((Object)this.userAccountService.addGold(param));
    }

    @ApiOperation(value="9-94-9 \u6839\u636e\u5e16\u5b50id\u83b7\u53d6\u6d41\u6c34\u91d1\u5e01\u6570", httpMethod="GET", notes="\u6839\u636e\u5e16\u5b50id\u83b7\u53d6\u6d41\u6c34\u91d1\u5e01\u6570")
    @GetMapping(value={"/countGoldByPostId"})
    public ResponseEntity<Integer> countGoldByPostId(@RequestParam(value="postId") Long postId, @RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.goldFlowService.countGoldByPostId(postId, userId));
    }

    @ApiOperation(value="9-94-10 \u83b7\u53d6\u6211\u7684\u8d26\u6237\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7684\u91d1\u5e01\u4f59\u989d\u548c\u73b0\u91d1\u4f59\u989d\u3001\u91d1\u5e01\u603b\u6536\u5165\u3001\u73b0\u91d1\u603b\u6536\u5165")
    @GetMapping(value={"/getUserAccount"})
    public ResponseEntity<UserAccountDTO> getUserAccount(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.userAccountService.getUserAccountAndEnableWithdraw(userId));
    }
}

