/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.model.ResultDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import com.bxm.localnews.user.model.param.VipQueryParam;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.param.AddTimesParam;
import com.bxm.localnews.user.param.OfflineBindRelationParam;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.activation.ActivationVipManager;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-89 [\u5185\u90e8]\u7528\u6237VIP\u76f8\u5173\u7684\u63a5\u53e3"})
@RequestMapping(value={"facade/user/vip"})
@RestController
public class UserVipFacadeController {
    private final ActivationVipManager activationVipManager;
    private final ActiveCodeService activeCodeService;
    private final UserMapper userMapper;
    private final UserVipService userVipService;

    @Autowired
    public UserVipFacadeController(ActivationVipManager activationVipManager, ActiveCodeService activeCodeService, UserMapper userMapper, UserVipService userVipService) {
        this.activationVipManager = activationVipManager;
        this.activeCodeService = activeCodeService;
        this.userMapper = userMapper;
        this.userVipService = userVipService;
    }

    @ApiOperation(value="9-89-1 \u624b\u52a8\u6fc0\u6d3b\u7528\u6237\u7684VIP\u8d44\u683c")
    @PostMapping(value={"manual/active"})
    public ResponseEntity<ResultDTO> manualActiveVip(@RequestParam(value="phoneNo") String phoneNo) {
        User user = this.userMapper.findByPhone(phoneNo);
        ResultDTO result = null;
        if (user == null) {
            result = ResultDTO.builder().success(Boolean.valueOf(false)).title(phoneNo).result(phoneNo + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7528\u6237").build();
        } else {
            ActivationUserVipParam param = new ActivationUserVipParam();
            param.setUserId(user.getId());
            param.setActivationVipEnum(ActivationVipEnum.MANUAL);
            Message message = this.activationVipManager.activationVip(param);
            result = message.isSuccess() ? ResultDTO.builder().success(Boolean.valueOf(true)).build() : ResultDTO.builder().success(Boolean.valueOf(false)).title(phoneNo).result(message.getLastMessage()).build();
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="9-89-2 \u6279\u91cf\u5bfc\u51fa\u6fc0\u6d3b\u7801\u548c\u5361\u53f7")
    @PostMapping(value={"batch/export"})
    public ResponseEntity<List<ActiveCodeDTO>> batchExport(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="limit") Integer limit) {
        return ResponseEntity.ok((Object)this.activeCodeService.execBatchExport(areaCode, limit.intValue()));
    }

    @ApiOperation(value="9-89-3 \u6fc0\u6d3b\u7801\u6279\u91cf\u7ed1\u5b9a\u7528\u6237")
    @PostMapping(value={"batch/bind"})
    public ResponseEntity<List<ResultDTO>> batchBind(@RequestBody List<OfflineBindRelationParam> params) {
        return ResponseEntity.ok((Object)this.activeCodeService.execBatchBind(params));
    }

    @ApiOperation(value="9-89-4 \u7ed9\u7528\u6237\u589e\u52a0\u6fc0\u6d3b\u7801\u7684\u53ef\u7528\u6b21\u6570")
    @PostMapping(value={"add/num"})
    public ResponseEntity<Message> addNum(@RequestBody AddTimesParam param) {
        return ResponseEntity.ok((Object)this.activeCodeService.addActiveTimes(param));
    }

    @ApiOperation(value="9-89-5 \u83b7\u53d6\u7528\u6237\u7684vip\u8be6\u7ec6\u4fe1\u606f")
    @PostMapping(value={"get/detail"})
    public ResponseEntity<VipInfoDetailDTO> getVipDetail(@RequestBody VipQueryParam param) {
        return ResponseEntity.ok((Object)this.userVipService.getVipDetail(param));
    }
}

