/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.attribute.UserFollowService;
import com.bxm.localnews.user.model.param.UserFollowTypeParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-88 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u5173\u6ce8\u76f8\u5173"})
@RequestMapping(value={"facade/user"})
@RestController
public class UserFollowFacadeController {
    private static final Logger log = LoggerFactory.getLogger(UserFollowFacadeController.class);
    private final UserFollowService userFollowService;

    @Autowired
    public UserFollowFacadeController(UserFollowService userFollowService) {
        this.userFollowService = userFollowService;
    }

    @ApiOperation(value="9-88-01 \u5224\u65ad\u7528\u6237\u662f\u5426\u5173\u6ce8\u4e86\u5bf9\u65b9")
    @GetMapping(value={"isFollow"})
    public ResponseEntity<Boolean> isFollow(@RequestParam(value="fromUserId") Long fromUserId, @RequestParam(value="toUserId") Long toUserId) {
        return ResponseEntity.ok((Object)this.userFollowService.isFollowed(fromUserId, toUserId));
    }

    @ApiOperation(value="9-88-02 \u662f\u5426\u5b58\u5728user\u5173\u6ce8\u4e86target\u7684\u5173\u6ce8\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237ID"), @ApiImplicitParam(name="targetUid", value="\u76ee\u6807\u7528\u6237ID")})
    @GetMapping(value={"hasFollowMsg"})
    public ResponseEntity<Boolean> hasFollowMsg(@RequestParam(value="userId") Long userId, @RequestParam(value="targetUid") Long targetUid) {
        return ResponseEntity.ok((Object)this.userFollowService.hasFollowMsg(userId, targetUid));
    }

    @ApiOperation(value="9-88-03 \u5173\u6ce8\u6216\u53d6\u6d88\u5173\u6ce8")
    @PostMapping(value={"follow"})
    public ResponseEntity<Boolean> follow(@RequestBody UserFollowTypeParam param) {
        return ResponseEntity.ok((Object)this.userFollowService.follow(param.getFromUserId(), param.getToUserId(), param.getType()));
    }

    @ApiOperation(value="9-88-04 \u5224\u65ad\u7528\u6237\u662f\u5426\u5173\u6ce8\u96c6\u5408\u4e2d\u7528\u6237")
    @GetMapping(value={"isFollows"})
    public ResponseEntity<List<Long>> isFollows(@RequestParam(value="fromUserId") Long fromUserId, @RequestParam(value="toUserIds") List<Long> toUserIds) {
        return ResponseEntity.ok((Object)this.userFollowService.isFolloweds(fromUserId, toUserIds));
    }
}

