/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.user.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.newidea.component.service.BaseService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegrationService
extends BaseService {
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    private void pushMsg(PushMessage pushMessage) {
        this.pushMsgSupplyFeignService.pushMsg(pushMessage);
    }

    public void pushChangeAccountMsg(AccountCashParam param) {
        String title = "\ud83d\udcb0\u65b0\u589e\u8d4f\u91d1" + param.getCash().setScale(2, 4) + "\u5143";
        if (StringUtils.isNotBlank((CharSequence)param.getInviteType()) && StringUtils.isNotBlank((CharSequence)param.getInvitedUserName())) {
            title = title + "\uff0c" + param.getInvitedUserName() + "\u901a\u8fc7\u60a8\u8f6c\u53d1\u7684\u3010" + InviteTypeEnum.valueOf((String)param.getInviteType()).getDesc() + "\u3011\u6ce8\u518c\u4e86\u672c\u5730\u4e07\u4e8b\u901a\u3002\u7ecf\u5e38\u8f6c\u53d1\uff0c\u60ca\u559c\u66f4\u591a\u54e6~";
        }
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.ADD_CASH);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)param.getUserId()));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        this.pushMsg(message);
    }

    public void pushInviteMsg(Long userId, String headImg, String nickName, Integer gold, Integer userType) {
        if (null == userType) {
            return;
        }
        String action = 0 == userType ? "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u52a0\u5165\u672c\u5730\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\uff0c\u5956\u52b1\u4f60" + gold + "\u6735\u5c0f\u7ea2\u82b1" : "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u518d\u6b21\u56de\u5230\u4e86\u672c\u5730\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\uff0c\u5956\u52b1\u4f60" + gold + "\u6735\u5c0f\u7ea2\u82b1";
        String title = nickName + action;
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.INVITE);
        Long msgId = this.nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("title", (Object)title);
        info.addExtend("icon", (Object)headImg);
        info.addExtend("nickname", (Object)nickName);
        info.addExtend("action", (Object)action);
        info.addExtend("userType", (Object)userType);
        info.addExtend("flowerNum", (Object)gold);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }

    public void sendSystemMessage(Long userId, int num) {
        String url = "wst://mine/userHomePage?userId=" + userId;
        String copyWrite = "\u6700\u8fd1\u6709" + num + "\u4eba\u67e5\u770b\u4e86\u4f60\u7684\u4e3b\u9875\uff0c\u770b\u770b\u90fd\u6709\u8c01\u3002";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.addExtend("msgId", (Object)this.nextId());
        info.addExtend("url", (Object)url);
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(copyWrite);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }
}

