package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.SignWarper;
import com.bxm.localnews.user.facade.fallback.AppVersionFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/1 13:36
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = AppVersionFallbackFactory.class)
public interface SignFeignService {

    @GetMapping("facade/activity/sign/list")
    ResponseEntity<SignWarper> listSignRecord(@RequestParam("userId") Long userId, @RequestParam("platform") int platform);
}
